/**
 * Created by Khalid.Alaraj on 16-August-2016.
 */

$.fn.dataTable.ext.errMode = 'throw';
$(document).ready(function() {
    var table = $('#shasha-table').DataTable( {
        "processing": true,
        "serverSide": true,
        "responsive": true,
        "ajax": "load_data.php?serv_id=null",
        "columns": [
            {
                "responsivePriority": 1,
                "data": "mn"
            },
            {
                "responsivePriority": 3,
                "data": "ser"
            },
            //{ "data": "ip" },
            {
                "responsivePriority": 4,
                "data": "vc"
            },
            {
                "responsivePriority": 2,
                "targets": -1,
                "data": "s"
            },
            {
                "responsivePriority": 5,
                "data": "vd"
            },
            {
                "responsivePriority": 6,
                "data": "cd"
            },
            {
                "orderable": false,
                "responsivePriority": 7,
                "targets": -1,
                "data": null,
                "defaultContent": '<i ="show log" data-toggle="modal" data-target="#det-modal" class="glyphicon glyphicon-eye-open click-view"></i>'
            }
        ],
        "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
            switch(aData['s']){
                case 'Pending':
                    $(nRow).children('td:nth(3)').css('color', 'red')
                    break;
                case 'Verified':
                    $(nRow).children('td:nth(3)').css('color', 'green')
                    break;
            }
        }
    } );
    $('#service-filter').prependTo('#shasha-table_wrapper');

    $('#shasha-table tbody').on( 'click', '.click-view', function () {
        var data = table.row( $(this).parents('tr') ).data();
        $.post('load_det.php',{nm:data['id']}).done(function(response){
            $(".modal-content").html(response);
        });
        //alert(data['id'] );
    } );

    $.getJSON('getservices.php',function(data){
        var options = [];
        $("#service").append("<option value=''>Choose Service</option>");
        $.each( data, function( key, option ) {
            options.push("<option value='" + option.id + "'>" + option.description + "</option>");
        });
        $("#service").append(options);
    });

    $('#service').on('change',function(e){
        table.ajax.url( 'load_data.php?serv_id='+$(this).val() ).load();
    });

} );